/**
* @package mod_vm_live_product
*
* @license		http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL, see LICENSE.php
* VM Live Product Search is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

/**
 * VM Live Product Search
 *
 * Used to process Ajax searches on a Virtuemart 1.1.2 Products.
 * Based on the excellent mod_pixsearch live search module designed by Henrik Hussfelt (henrik@pixpro.net - http://pixpro.net)
 * @author		John Connolly <webmaster@GJCWebdesign.com>
 * @package		mod_vm_live_product
 * @since		1.5
 * @version     0.6.0
 */

/*
Global language vars, to be set from languagefiles through mod_vm_live_product.
*/
var _txtResults	= null;
var _txtClose	= null;
var _txtSearch	= null;
var _txtOneresult= null;
var _txtRedirect=null;
var _txtSearchLink=null;
var _txtURIBase	= null;
var _vmtemplate=null;
var _txtNoResult=null;
var _searchBy=null;
var _redirecturl=null;
/*
Set global language vars
*/
function setSpecifiedLanguage(a,b,c,d,e,f,g,h,j,k,l){
	_txtResults	= a;
	_txtClose	= b;
	_txtSearch	= c;
	_txtOneresult= d;
	_txtRedirect=e;
	_txtSearchLink=f;
	_txtURIBase	= g;
	_vmtemplate = h;
	_txtNoResult = j;
	_searchBy   = k;
	_redirecturl   = l;
}

/*
When DOMReady, execute js_code.
*/
window.addEvent('domready', function() {
	var addSearchResult = function() {
		var result_div = $('vmlp_results');
		var row="vmlp_row_2";
		var requrl = (_redirecturl)+"index.php?keyword1="+$('vmlp_search_str').value+"&Search=Search&Itemid=1&option=com_virtuemart&page=shop.browse&search_limiter="+(_searchBy);
		
		var res_header = new Element('div', {'class': 'vmlp_header' }).setHTML(_txtResults).injectInside(result_div);
		var link = new Element('a', {'id': 'vmlp_link' }).setProperty('href','#').setHTML(_txtClose).injectBefore(res_header);
		$('vmlp_link').addEvent('click', function(e) {
			e = new Event(e).stop();
			$('vmlp_search_str').value = _txtSearch;
			$('vmlp_results').setHTML('<a href="http://www.gjcwebdesign.com">Web Design England Belgium</a>').removeClass('vmlp_results').setStyle('visibility', 'hidden');
		});

		result_div.addClass('vmlp_results');
		 var testresult = $$('#vmlpsearch_tmpdiv #zero_results');
		  search_res = $$('#vmlpsearch_tmpdiv '+_vmtemplate);	  
		var test2 = search_res.length;
	    var test1 =testresult.length;
		var test3= test2+test1;
		
		/*************NO result***/
		if (test3==1){
		var el = new Element('div', {'class': row }).setHTML(_txtNoResult );	
						el.inject(result_div);
					}
		/***** more than 1 result****/
			if(test3 > 1) search_res.each(function(res) {
		var res_data='';
			res_data=res.getChildren();	
			
				if(res_data.length > 0){
						res_data.each(function(r) {	
								if(row == "vmlp_row_2") row = "vmlp_row_1";
									else row = "vmlp_row_2";
										var suri=r.getProperty('href');
										
										var suri2=suri.replace(/index2/,"index");
												var el = new Element('div', {'class': row });
												var link = new Element('a').setProperty('href',suri2).injectInside(el);
												var name = new Element('p').setHTML(r.getText()).injectInside(link);
						el.inject(result_div);
			});
		}
	});
		/*************One result***/
			if (test3==0){
			var el = new Element('div', {'class': row }).setHTML(_txtOneresult+' "'+$('vmlp_search_str').value+'"'+_txtRedirect+'&nbsp; <img src="'+_txtURIBase+'modules/mod_vm_live_product/css/loadingcircle.gif" height="16px" width="16px"><br/><br/>' );	
						el.inject(result_div);
     		/*redirect to single result product page or no result*/
        this.location.href = requrl;
		}
	}
				/*replace Search... text*/
	$('vmlp_search_str').addEvent('click', function(e) {
		if($('vmlp_search_str').value == _txtSearch) $('vmlp_search_str').value = '';
	});

	$('vmlp_search_str').onkeyup = function(){
		var curtime = new Date();
		var url = _txtURIBase+'index2.php';
				/*show throbber*/
			$('vmlp_timer').setStyle('visibility', 'visible');
				/*check search string length > 2*/
		tt=$('vmlp_search_str').value;
		tl=tt.length
			if(tl<3){
			$('vmlp_results').empty().removeClass('vmlp_results').setStyle('visibility', 'hidden');
					/*show 3 letter message*/
			$('vmlp_3letters').setStyle('visibility', 'visible');
		}
		else{
			var req = new Ajax(url, {
				method: 'get',
				delay : 300,
				data: {
				'option' : 'com_virtuemart',
				'page' : 'shop.browse',
				'keyword1' : $('vmlp_search_str').value,
				'search' : 'search' ,
				'search_limiter' : _searchBy,
				'r' : curtime.getTime()
				
				},
				onComplete: function(results) {
						/*hide throbber*/
			$('vmlp_timer').setStyle('visibility', 'hidden');
						/*hide 3 letter message*/
			$('vmlp_3letters').setStyle('visibility', 'hidden');
      
                   var theNewEle = new Element('div');
						theNewEle.setHTML(results);
						var vmlpsearch_tmpdiv = $('vmlpsearch_tmpdiv');
						var zr_list = theNewEle.getElements('.zero_results');//test for no result
						var zeroResults = (zr_list.length > 0);
						if (zeroResults)
						{
							var el = new Element('div', {'id': 'zero_results' }).setHTML(zr_list[0].innerHTML );	
						el.inject(vmlpsearch_tmpdiv);
						}
	
					else{
						theNewEle.getElements('.browseProductTitle').each(function(r) {
						vmlpsearch_tmpdiv.appendChild(r);
						});
				}

					$('vmlp_results').empty().removeClass('vmlp_results').setStyle('visibility', 'visible');
					addSearchResult();
					$('vmlpsearch_tmpdiv').empty().setStyle('visibility','visible');
					
				}	
		});
			var rq = req.request.delay(1000,req);
			$('vmlp_search_str').onkeydown = function(){$clear(rq);};
		}
	}
});

