<?php
/**
* @package mod_vm_live_product
*
* @license		http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL, see LICENSE.php
* VM Live Product Search is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

/**
 * VM Live Product Search
 *
 * Used to process Ajax searches on a Virtuemart 1.1.2 Products.
 * Based on the excellent mod_pixsearch live search module designed by Henrik Hussfelt (henrik@pixpro.net - http://pixpro.net)
 * @author		John Connolly <webmaster@GJCWebdesign.com>
 * @package		mod_vm_live_product
 * @since		1.5
 * @version     0.5
 */
// no direct access
defined('_JEXEC') or die('Restricted access');
/* Load the virtuemart main parse code */
if( !isset( $mosConfig_absolute_path ) ) {
	$mosConfig_absolute_path = $GLOBALS['mosConfig_absolute_path']	= JPATH_SITE;
}
global $mosConfig_absolute_path, $VM_LANG, $page;
require_once( $mosConfig_absolute_path.'/components/com_virtuemart/virtuemart_parser.php' );
?>
<form name="pp_search" id="pp_search" action="<?php echo JURI::Base()?>" method="get">
<div class="vmlpsearch<?php echo $params->get('moduleclass_sfx'); ?>" style="position:relative;">
	<div class="vmlp_pretext"><?php echo $params->get('pretext'); ?></div>

		<input class="inputbox" id="vmlp_search_str" name="keyword" type="text" value="<?php echo JText::_('SEARCHVMLP'); ?>" autocomplete="off" />
		<div id="vmlp_timer" style="visibility:hidden;"><img src="<?php echo JURI::Base()?>modules/mod_vm_live_product/css/loadingcircle.gif" height="16px" width="16px"></div>
		<div id="vmlp_3letters" style="visibility:hidden;"><?php echo JText::_('LETTERVMLP'); ?></div>
	<input type="hidden" name="search" value="search"/>

	<input type="hidden" name="Itemid" value="<?php echo intval(@$_REQUEST['Itemid']) ?>" />
		<input type="hidden" name="option" value="com_virtuemart" />
		<input type="hidden" name="page" value="shop.browse" />
	<?php if ($params->get('include_but')== 1){
		echo '<input class="button" type="submit" value="'.$VM_LANG->_('PHPSHOP_SEARCH_TITLE').'" name="Search"/>';}?>
		
		<?php if ($params->get('include_advsearch')== 1){
		echo '<br/><a href="'.$params->get('search_page').'">'.$VM_LANG->_('PHPSHOP_ADVANCED_SEARCH').' </a>';}?>
		
	<?php if ($params->get('vmtemplate')== 'altelement'){
		$template_element = $params->get('altelement');
	}else{
		$template_element = $params->get('vmtemplate');
	}?>
	
	<?php
		$search_by = $params->get('search_by');
		$redirect_url = $params->get('redirect_url');
	?>
	
	<div class="vmlp_posttext"><?php echo $params->get('posttext'); ?></div>
	<div id="vmlp_results"><a href="http://www.gjcwebdesign.com">Web Design England UK Joomla VirtueMart Belgium</a></div>
	<script type="text/javascript">
	setSpecifiedLanguage(
		'<?php echo JText::_('RESULTSVMLP'); ?>',
		'<?php echo JText::_('CLOSEVMLP'); ?>',
		'<?php echo JText::_('SEARCHVMLP'); ?>',
		'<?php echo JText::_('ONERESULTVMLP'); ?>',
		'<?php echo JText::_('REDIRECTVMLP'); ?>',
		'<?php echo JURI::Base().htmlentities($params->get('search_page')); ?>',
		'<?php echo JURI::Base()?>',
		'<?php echo $template_element; ?>',
		'<?php echo JText::_('NORESULTVMLP'); ?>',
		'<?php echo $search_by; ?>',
		'<?php echo $redirect_url; ?>'
	);
	</script>
</div>
<div id="vmlpsearch_tmpdiv"  style="visibility:hidden;display:none;"></div>
</form>